import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.io.*;
import java.util.Scanner;

/**
 * Write a description of class SpreadSheet here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class SpreadSheet  extends World
{

    /**
     * Constructor for objects of class SpreadSheet.
     * 
     */
    public SpreadSheet()
    {    
        super(6*7, 40, 15);
        renderTable();
    }
    
    public void renderTable() {
        GreenfootImage img=getBackground();
        table.renderToImage(img);
        setBackground(img);
    }
    
    public void readCSVFile(String fileName) {
        try {
            Scanner sc=new Scanner(new File(fileName));
            int row=0;
            while(sc.hasNextLine()) {
                String[] elems=sc.nextLine().split(",");
                for(int i=0; i<elems.length; i++) {
                    elems[i]=elems[i].trim();
                    if(elems[i].startsWith("\"")) {
                        elems[i]=elems[i].substring(1,elems[i].length()-1);
                    }
                    table.set(row,i,elems[i]);
                }
                row++;
            }
            sc.close();
            renderTable();
        } catch(IOException e) {
        }
    }
    
    public void changeData() {
        table.set(0,0,5);
        renderTable();
        repaint();
    }
    
    private DataTable table=new DataTable();
}
