import greenfoot.*;
import java.util.*;
import java.awt.Color;

/**
 * Write a description of class DataTable here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class DataTable {
    /**
     * 
     */
    public int maxRows() {
        return data.size();
    }
    
    /**
     * 
     */
    public int maxColumns() {
        int max=0;
        for(int i=0; i<data.size(); i++) {
            if(data.get(i).size()>max) {
                max=data.get(i).size();
            }
        }
        return max;
    }
    
    /**
     * 
     */
    public boolean hasData(int r,int c) {
        try {
            return data.get(r).get(c)!=null;
        } catch(IndexOutOfBoundsException e) {
            return false;
        }
    }
    
    /**
     * 
     */
    public Object get(int r,int c) {
        if(r>=data.size() || c>=data.get(r).size()) return null;
        return data.get(r).get(c);
    }
    
    /**
     * 
     */
    public void set(int r,int c,double value) {
        while(r>data.size()-1) {
            data.add(new ArrayList<Object>());
        }
        while(c>data.get(r).size()-1) {
            data.get(r).add(null);
        }
        data.get(r).set(c,value);
    }
    
    /**
     * 
     */
    public void set(int r,int c,String value) {
        while(r>data.size()-1) {
            data.add(new ArrayList<Object>());
        }
        while(c>data.get(r).size()-1) {
            data.get(r).add(null);
        }
        try {
            double v=Double.parseDouble(value);
            data.get(r).set(c,v);
        } catch(NumberFormatException e) {
            data.get(r).set(c,value);
        }
    }

    /**
     * 
     */
    public void renderToImage(GreenfootImage img) {
        int rows=maxRows();
        int cols=maxColumns();
        int fillRows=Math.max(40,rows);
        int fillCols=Math.max(10,cols);
        img.clear();
        img.setColor(Color.white);
        img.fillRect(0,0,fillCols*CELL_WIDTH,fillRows*CELL_HEIGHT);
        img.setColor(Color.black);
        for(int i=0; i<fillRows; i++) {
            img.drawLine(0,(i+1)*CELL_HEIGHT,(fillCols)*CELL_WIDTH,(i+1)*CELL_HEIGHT);
        }
        for(int i=0; i<fillCols; i++) {
            img.drawLine((i+1)*CELL_WIDTH,0,(i+1)*CELL_WIDTH,(fillRows)*CELL_HEIGHT);
        }
        for(int i=0; i<rows; i++) {
            for(int j=0; j<data.get(i).size(); j++) {
                if(data.get(i).get(j)!=null) {
                    img.drawString(data.get(i).get(j).toString(),j*CELL_WIDTH+2,(i+1)*CELL_HEIGHT-2);
                }
            }
        }
    }
    
    private List<List<Object>> data=new ArrayList<List<Object>>();
    private static final int CELL_HEIGHT=15;
    private static final int CELL_WIDTH=90;
}
