import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class LabGrid here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class LabGrid extends World
{

    /**
     * Constructor for objects of class LabGrid.
     * 
     */
    public LabGrid()
    {    
        super(10, 10, 80);
        
        setBackground("space.jpg"); 
        populateWorld();
        addObject(new Selector(),sx,sy);
        setPaintOrder(Selector.class,Piece.class);
    }
    
    private void populateWorld() {
        for(int i=0; i<getWidth(); ++i) {
            for(int j=getHeight()-1; j>=0; --j) {
                boolean[] badColor=new boolean[Piece.numColors()];
                if(i>1) {
                    Piece p1=(Piece)getObjectsAt(i-2,j,Piece.class).get(0);
                    Piece p2=(Piece)getObjectsAt(i-1,j,Piece.class).get(0);
                    if(p1.getColor()==p2.getColor()) {
                        badColor[p1.getColor()]=true;
                    }
                }
                if(j<getHeight()-2) {
                    Piece p1=(Piece)getObjectsAt(i,j+2,Piece.class).get(0);
                    Piece p2=(Piece)getObjectsAt(i,j+1,Piece.class).get(0);
                    if(p1.getColor()==p2.getColor()) {
                        badColor[p1.getColor()]=true;
                    }
                }
                Piece newPiece=new Piece(badColor);
                addObject(newPiece,i,j);
            }
        }
    }
    
    public void checkBoard() {
        for(int i=0; i<getWidth(); ++i) {
            checkRow(i);
        }
        for(int i=0; i<getHeight(); ++i) {
            checkColumn(i);
        }
        for(Object p:getObjects(Piece.class)) {
            if(((Piece)p).getRemoved()) {
                removeObject((Piece)p);
            }
        }
    }
    
    private void checkRow(int row) {
        int cur=-1;
        int cnt=0;
        for(int i=0; i<getWidth(); ++i) {
            Piece p=(Piece)getObjectsAt(i,row,Piece.class).get(0);
            if(p.getColor()==cur) {
                cnt++;
            } else {
                if(cnt>=3) {
                    setRemovedOnRow(row,i-1,cnt);
                }
                cnt=1;
                cur=p.getColor();
            }
        }
        if(cnt>=3) {
            setRemovedOnRow(row,getWidth()-1,cnt);
        }
    }
    
    private void setRemovedOnRow(int row,int col,int cnt) {
        for(int i=0; i<cnt; ++i) {
            Piece p=(Piece)getObjectsAt(col-i,row,Piece.class).get(0);
            p.setRemoved();
        }
    }
    
    private void checkColumn(int col) {
        int cur=-1;
        int cnt=0;
        for(int i=0; i<getHeight(); ++i) {
            Piece p=(Piece)getObjectsAt(col,i,Piece.class).get(0);
            if(p.getColor()==cur) {
                cnt++;
            } else {
                if(cnt>=3) {
                    setRemovedOnCol(i-1,col,cnt);
                }
                cnt=1;
                cur=p.getColor();
            }
        }
        if(cnt>=3) {
            setRemovedOnCol(getHeight()-1,col,cnt);
        }
    }
    
    private void setRemovedOnCol(int row,int col,int cnt) {
        for(int i=0; i<cnt; ++i) {
            Piece p=(Piece)getObjectsAt(col,row-i,Piece.class).get(0);
            p.setRemoved();
        }
    }
    
    public void addAtTop() {
        for(int i=0; i<getWidth(); ++i) {
            if(getObjectsAt(i,0,Piece.class).isEmpty()) {
                addObject(new Piece(),i,0);
            }
        }
    }
    
    public void dropPieces() {
        for(Object o:getObjects(Piece.class)) {
            ((Piece)o).drop();
        }
    }
    
    private int sx=4;
    private int sy=4;
}
