package GoobersLab;

import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Piece here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Piece extends Actor
{
    public Piece() {
        color=Greenfoot.getRandomNumber(images.length);
        setImage(images[color]);
    }
    
    public Piece(boolean[] badColors) {
        do {
            color=Greenfoot.getRandomNumber(images.length);
        } while(badColors[color]);
        setImage(images[color]);
    }
    
    /**
     * Act - do whatever the Piece wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        if(getY()<getWorld().getHeight()-1 && getWorld().getObjectsAt(getX(),getY()+1,Piece.class).isEmpty()) {
            setLocation(getX(),getY()+1);
        }
    }
    
    public int getColor() {
        return color;
    }
    
    public void setColor(int newColor) {
        if(newColor<0 || newColor>=images.length) return;
        color=newColor;
        setImage(images[color]);
    }
    
    public void setRemoved() {
        removed=true;
    }
    
    public boolean getRemoved() {
        return removed;
    }
    
    public static int numColors() {
        return images.length;
    }
    
    private int color;
    private boolean removed;
    
    private static GreenfootImage[] images={new GreenfootImage("button-purple.png"),
            new GreenfootImage("button-blue.png"),new GreenfootImage("button-red.png"),
            new GreenfootImage("button-green.png"),new GreenfootImage("button-yellow.png")};
}
