package GoobersLab;

import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class LabGrid here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class LabGrid extends World
{

    /**
     * Constructor for objects of class LabGrid.
     * 
     */
    public LabGrid()
    {    
        super(10, 10, 60);
        
        setBackground("space.jpg"); 
        populateWorld();
        addObject(new Selector(),4,4);
        setPaintOrder(Selector.class,Piece.class);
    }
    
    public void act() {
        MouseInfo mi=Greenfoot.getMouseInfo();
        boolean falling=getObjects(Piece.class).size()!=getWidth()*getHeight();
        if(!falling && mi!=null && mi.getClickCount()>0) {
            Selector sel=(Selector)getObjects(Selector.class).get(0);
            int dx=Math.abs(sel.getX()-mi.getX());
            int dy=Math.abs(sel.getY()-mi.getY());
            if(dx+dy==1) {
                swapPieces(sel.getX(),sel.getY(),mi.getX(),mi.getY());
            }
            sel.setLocation(mi.getX(),mi.getY());
        }
        addAtTop();
        if(!falling) {
            checkBoard();
        }
    }
    
    private void populateWorld() {
        for(int i=0; i<getWidth(); ++i) {
            for(int j=0; j<getHeight(); ++j) {
                boolean[] badColor=new boolean[Piece.numColors()];
                if(i>1) {
                    Piece p1=(Piece)getObjectsAt(i-2,j,Piece.class).get(0);
                    Piece p2=(Piece)getObjectsAt(i-1,j,Piece.class).get(0);
                    if(p1.getColor()==p2.getColor()) {
                        badColor[p1.getColor()]=true;
                    }
                }
                if(j>1) {
                    Piece p1=(Piece)getObjectsAt(i,j-2,Piece.class).get(0);
                    Piece p2=(Piece)getObjectsAt(i,j-1,Piece.class).get(0);
                    if(p1.getColor()==p2.getColor()) {
                        badColor[p1.getColor()]=true;
                    }
                }
                Piece newPiece=new Piece(badColor);
                addObject(newPiece,i,j);
            }
        }
    }
    
    private void swapPieces(int px1,int py1,int px2,int py2) {
        Piece p1=(Piece)getObjectsAt(px1,py1,Piece.class).get(0);
        Piece p2=(Piece)getObjectsAt(px2,py2,Piece.class).get(0);
        p1.setLocation(px2,py2);
        p2.setLocation(px1,py1);
    }
    
    private void checkBoard() {
        for(int i=0; i<getWidth(); ++i) {
            checkRow(i);
        }
        for(int i=0; i<getHeight(); ++i) {
            checkColumn(i);
        }
        for(Object p:getObjects(Piece.class)) {
            if(((Piece)p).getRemoved()) {
                removeObject((Piece)p);
            }
        }
    }
    
    private void checkRow(int row) {
        int cur=-1;
        int cnt=0;
        for(int i=0; i<getWidth(); ++i) {
            Piece p=(Piece)getObjectsAt(i,row,Piece.class).get(0);
            if(p.getColor()==cur) {
                cnt++;
            } else {
                if(cnt>=3) {
                    setRemovedOnRow(row,i-1,cnt);
                }
                cnt=1;
                cur=p.getColor();
            }
        }
        if(cnt>=3) {
            setRemovedOnRow(row,getWidth()-1,cnt);
        }
    }
    
    private void setRemovedOnRow(int row,int col,int cnt) {
        for(int i=0; i<cnt; ++i) {
            Piece p=(Piece)getObjectsAt(col-i,row,Piece.class).get(0);
            p.setRemoved();
        }
    }
    
    private void checkColumn(int col) {
        int cur=-1;
        int cnt=0;
        for(int i=0; i<getHeight(); ++i) {
            Piece p=(Piece)getObjectsAt(col,i,Piece.class).get(0);
            if(p.getColor()==cur) {
                cnt++;
            } else {
                if(cnt>=3) {
                    setRemovedOnCol(i-1,col,cnt);
                }
                cnt=1;
                cur=p.getColor();
            }
        }
        if(cnt>=3) {
            setRemovedOnCol(getHeight()-1,col,cnt);
        }
    }
    
    private void setRemovedOnCol(int row,int col,int cnt) {
        for(int i=0; i<cnt; ++i) {
            Piece p=(Piece)getObjectsAt(col,row-i,Piece.class).get(0);
            p.setRemoved();
        }
    }
    
    private void addAtTop() {
        for(int i=0; i<getWidth(); ++i) {
            if(getObjectsAt(i,0,Piece.class).isEmpty()) {
                addObject(new Piece(),i,0);
            }
        }
    }
}
