import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.util.List;

/**
 * This is where all the action of the game happens.
 * 
 * @param RATE how fast the game goes
 * @param TOLERANCE how close an Arrow has to be to it's matching outline to be removed
 * @author Impirator 
 * @version 0.5
 */
public class Screen extends World
{
    /**
     * Constructor for objects of class Screen.  Creates the outline shapes at the top.
     * 
     */
    public Screen() {    
        super(173,160,5);
        for(int i=0; i<9; i++) {
            if(i<4) addObject(new Arrow(true), 20*i+12, 30/2);
            else if(i>4) addObject(new Arrow(true), 20*i, 30/2);
        }
    }
    
    public void act() {
        if(ctr%RATE==0) {
            randomArrows();
        }
        checkKeys();
        ctr++;
    }
    
    public void checkKeys() {
        // Fill this in.
    }
    
    public void randomArrows() {
        int rand = Greenfoot.getRandomNumber(2);
        if(rand==0) {
            addArrowRandom();
        }
        else if(rand == 1) {
            addDoubleRandom();
        }
    }
    
    public void addArrowRandom() {
            int rand = Greenfoot.getRandomNumber(4);
            addObject(new Arrow(rand*90,keys[rand]),columnLocs[rand],getHeight());
            addObject(new Arrow(rand*90,keys[rand+4]),columnLocs[rand+4],getHeight());
    }
    
    public void addDoubleRandom() {
        int rand = Greenfoot.getRandomNumber(4);
        int rand2 = Greenfoot.getRandomNumber(4);
        
        addObject(new Arrow(rand*90,keys[rand]),columnLocs[rand],getHeight());
        addObject(new Arrow(rand*90,keys[rand+4]),columnLocs[rand+4],getHeight());

        addObject(new Arrow(rand2*90,keys[rand2]),columnLocs[rand2],getHeight());
        addObject(new Arrow(rand2*90,keys[rand2+4]),columnLocs[rand2+4],getHeight());
    }
    
    // Ordered in increasing rotational increments.
    private static final int[] columnLocs = {32,12,52,72,120,100,140,160};
    private static final String[] keys = {"a","s","w","d","down","left","up","right"};
    private static final int RATE = 40;
    // Y-value of the outline Arrows
    private static final int OUTLINE_HEIGHT = 15; 
    // Vertical range around OUTLINE_HEIGHT inside which Arrows can be removed.
    private static final int TOLERANCE = 4;
    private static int ctr = 0;
}
