import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Arrow here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Arrow extends Actor
{
    public Arrow() {
        setImage("DDRarrow_small.png");
    }
    public Arrow(int rotation, String k) {
        setRotation(rotation);
        key = k;
        setImage("DDRarrow_small.png");
    }
    public Arrow(boolean isOutline) {
        if(isOutline) {
            setImage("DDRoutline.png");
            setRotation(Arrow.getNextRotation());
            Arrow.setNextRotation();
            outline = true;
        }
        else setImage("DDRarrow_small.png");
    }

    public static int getNextRotation() { return nextRotation; }
    
    public static void setNextRotation() {
        switch(Arrow.getNextRotation()) {
            case 90:
                nextRotation=0;
                break;
            case 180:
                nextRotation=270;
                break;
            case 270:
                nextRotation=90;
                break;
            case 0:
                nextRotation=180;
                break;
        }
    }
    
    public void act() 
    {
        if(!outline) move();
        if(getY()==0) getWorld().removeObject(this);
    }
    
    public void move() {
        if(getY()-1>=0) setLocation(getX(),getY()-1);
    }
    
    public int printOutlineLocations() {
        return getX();
    }
    
    public boolean isOutline() { return outline; }
    
    public String getKey() { return key; }
    
    private static int nextRotation = 90; // First points right.
    private boolean outline = false;
    private String key;
}
